@extends('layouts.app')

@section('title', 'Notifications')

@section('content')
<div class="max-w-7xl mx-auto px-2 sm:px-4 lg:px-8">
    <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-4 sm:mb-6 gap-3">
        <h1 class="text-2xl sm:text-3xl font-bold text-gray-800">Notifications</h1>
        <div class="flex gap-2">
            <form method="POST" action="{{ route('admin.notifications.mark-all-read') }}" class="inline">
                @csrf
                <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-3 sm:px-4 py-2 rounded text-sm sm:text-base">
                    Mark All as Read
                </button>
            </form>
            <a href="{{ route('admin.dashboard') }}" class="bg-gray-600 hover:bg-gray-700 text-white px-3 sm:px-4 py-2 rounded text-sm sm:text-base">
                <i class="fas fa-arrow-left"></i> <span class="hidden sm:inline">Back</span>
            </a>
        </div>
    </div>

    @if(session('success'))
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
            {{ session('success') }}
        </div>
    @endif

    <div class="bg-white rounded-lg shadow">
        @forelse($notifications as $notification)
            <div class="border-b border-gray-200 p-4 sm:p-6 {{ $notification->read_at ? 'bg-white' : 'bg-blue-50' }}">
                <div class="flex justify-between items-start">
                    <div class="flex-1">
                        <div class="flex items-start gap-3">
                            @if(isset($notification->data['type']))
                                @if($notification->data['type'] === 'doctor_registration')
                                    <div class="p-2 bg-blue-100 rounded-full">
                                        <i class="fas fa-user-md text-blue-600"></i>
                                    </div>
                                @elseif($notification->data['type'] === 'prescription_created')
                                    <div class="p-2 bg-green-100 rounded-full">
                                        <i class="fas fa-prescription text-green-600"></i>
                                    </div>
                                @else
                                    <div class="p-2 bg-gray-100 rounded-full">
                                        <i class="fas fa-bell text-gray-600"></i>
                                    </div>
                                @endif
                            @else
                                <div class="p-2 bg-gray-100 rounded-full">
                                    <i class="fas fa-bell text-gray-600"></i>
                                </div>
                            @endif
                            
                            <div class="flex-1">
                                <p class="font-semibold text-gray-800 text-sm sm:text-base {{ $notification->read_at ? '' : 'font-bold' }}">
                                    {{ $notification->data['message'] ?? 'New notification' }}
                                </p>
                                
                                @if(isset($notification->data['type']) && $notification->data['type'] === 'doctor_registration')
                                    <div class="mt-2 text-sm text-gray-600">
                                        <p><strong>Doctor:</strong> {{ $notification->data['doctor_name'] ?? 'N/A' }}</p>
                                        <p><strong>Practice Number:</strong> {{ $notification->data['practice_number'] ?? 'N/A' }}</p>
                                    </div>
                                    <div class="mt-3">
                                        <a href="{{ route('admin.doctors') }}" class="text-blue-600 hover:text-blue-900 text-sm">
                                            <i class="fas fa-eye"></i> Review Doctor
                                        </a>
                                    </div>
                                @elseif(isset($notification->data['type']) && $notification->data['type'] === 'prescription_created')
                                    <div class="mt-2 text-sm text-gray-600">
                                        <p><strong>Prescription #:</strong> {{ $notification->data['prescription_number'] ?? 'N/A' }}</p>
                                        <p><strong>Patient:</strong> {{ $notification->data['patient_name'] ?? 'N/A' }}</p>
                                        <p><strong>Doctor:</strong> {{ $notification->data['doctor_name'] ?? 'N/A' }}</p>
                                    </div>
                                    <div class="mt-3">
                                        <a href="{{ route('prescriptions.show', $notification->data['prescription_id']) }}" class="text-blue-600 hover:text-blue-900 text-sm">
                                            <i class="fas fa-eye"></i> View Prescription
                                        </a>
                                    </div>
                                @endif
                                
                                <p class="text-xs text-gray-500 mt-2">{{ $notification->created_at->diffForHumans() }}</p>
                            </div>
                        </div>
                    </div>
                    
                    @if(!$notification->read_at)
                        <form method="POST" action="{{ route('admin.notifications.mark-read', $notification->id) }}" class="ml-4">
                            @csrf
                            <button type="submit" class="text-gray-400 hover:text-gray-600" title="Mark as read">
                                <i class="fas fa-check-circle"></i>
                            </button>
                        </form>
                    @endif
                </div>
            </div>
        @empty
            <div class="p-8 text-center text-gray-500">
                <i class="fas fa-bell-slash text-4xl mb-4"></i>
                <p>No notifications found.</p>
            </div>
        @endforelse
    </div>

    @if($notifications->hasPages())
        <div class="mt-4">
            {{ $notifications->links() }}
        </div>
    @endif
</div>
@endsection

